IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Localidades_Totales') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Localidades_Totales
END
GO

CREATE FUNCTION [dbo].[CF_Localidades_Totales](@pId_Sector SMALLINT)
RETURNS INT
AS
BEGIN
DECLARE @Cantidad_Localidades_Totales		INT
DECLARE @Cantidad_Productos_Del_Sector		INT
DECLARE @Flag_Ubic_Fija						TINYINT

-------------------------------------------------------------------------------------------------------------------------------------

SELECT 
TOP 1
@Flag_Ubic_Fija = ISNULL(Flag_Ubic_Fija, 0)
FROM Empresas_Sedes_Sectores
WHERE 
Id_Sector = @pId_Sector

IF(@Flag_Ubic_Fija = 1)
BEGIN
	--Son todos los productos (Asientos) que pertenecen al Id_Sector
	SET @Cantidad_Localidades_Totales = ISNULL((SELECT COUNT(*) FROM Productos WHERE Tipo = 'L' AND Activo = 1 AND Id_Sector = @pId_Sector), 0)
END
ELSE
BEGIN
	--Es la minima de cantidad de los productos del sector (Hablado con Gabriel 19/04/2022) (Ej. Popular sin numerar)
	SET @Cantidad_Localidades_Totales = ISNULL((SELECT MIN(ISNULL(Estiba_Max, 0)) FROM Productos WHERE Tipo = 'L' AND Activo = 1 AND Id_Sector = @pId_Sector), 0)
END

-------------------------------------------------------------------------------------------------------------------------------------

/* Antes del 19/04/2022
SET @Cantidad_Productos_Del_Sector = ISNULL((SELECT COUNT(*) FROM Productos WHERE Tipo = 'L' AND Activo = 1 AND Id_Sector = @pId_Sector), 0)

IF (@Cantidad_Productos_Del_Sector = 1)
BEGIN
	--Es un solo producto (Ej. Popular sin numerar) que tiene la cantidad maxima de ocupacion
	SET @Cantidad_Localidades_Totales = ISNULL((SELECT ISNULL(Estiba_Max, 0) FROM Productos WHERE Tipo = 'L' AND Activo = 1 AND Id_Sector = @pId_Sector), 0)
END
ELSE
BEGIN
	--Son todos los productos (Asientos) que pertenecen al Id_Sector
	SET @Cantidad_Localidades_Totales = ISNULL((SELECT COUNT(*) FROM Productos WHERE Tipo = 'L' AND Activo = 1 AND Id_Sector = @pId_Sector), 0)
END
*/

-------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@Cantidad_Localidades_Totales, 0)
END
